/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLConfiguration;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;

public class MSXMLJavaScriptEnvironment {
    private final MSXMLConfiguration config_;
    private Map<Class<? extends MSXMLScriptable>, Scriptable> prototypes_;

    public MSXMLJavaScriptEnvironment(BrowserVersion browserVersion) throws Exception {
        this.config_ = MSXMLConfiguration.getInstance(browserVersion);
        HashMap<String, ScriptableObject> prototypesPerJSName = new HashMap<String, ScriptableObject>();
        HashMap<Class<? extends MSXMLScriptable>, Scriptable> prototypes = new HashMap<Class<? extends MSXMLScriptable>, Scriptable>();
        FallbackCaller fallbackCaller = new FallbackCaller();
        for (ClassConfiguration classConfiguration : this.config_.getAll()) {
            ScriptableObject prototype = MSXMLJavaScriptEnvironment.configureClass(classConfiguration);
            if (classConfiguration.isJsObject()) {
                prototypes.put(classConfiguration.getHostClass(), prototype);
            }
            prototypesPerJSName.put(classConfiguration.getHostClass().getSimpleName(), prototype);
        }
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = this.config_.getClassConfiguration(name);
            Scriptable prototype = (Scriptable)entry.getValue();
            if (prototype.getPrototype() != null) {
                prototype = prototype.getPrototype();
            }
            if (!StringUtils.isEmpty(config.getExtendedClassName())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(fallbackCaller);
        }
        this.prototypes_ = prototypes;
    }

    private static ScriptableObject configureClass(ClassConfiguration config) throws InstantiationException, IllegalAccessException {
        Class<? extends HtmlUnitScriptable> jsHostClass = config.getHostClass();
        ScriptableObject prototype = jsHostClass.newInstance();
        MSXMLJavaScriptEnvironment.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        MSXMLJavaScriptEnvironment.configureConstants(config, scriptable);
        Map<String, ClassConfiguration.PropertyInfo> propertyMap = config.getPropertyMap();
        for (String propertyName : propertyMap.keySet()) {
            ClassConfiguration.PropertyInfo info = propertyMap.get(propertyName);
            Method readMethod = info.getReadMethod();
            Method writeMethod = info.getWriteMethod();
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
        int attributes = 2;
        for (Map.Entry<String, Method> functionInfo : config.getFunctionEntries()) {
            String functionName = functionInfo.getKey();
            Method method = functionInfo.getValue();
            FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
            scriptable.defineProperty(functionName, functionObject, 2);
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (ClassConfiguration.ConstantInfo constantInfo : config.getConstants()) {
            scriptable.defineProperty(constantInfo.getName(), constantInfo.getValue(), 5);
        }
    }

    public Class<? extends MSXMLScriptable> getJavaScriptClass(Class<?> c) {
        return this.config_.getDomJavaScriptMapping().get(c);
    }

    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    private static class FallbackCaller
    extends ScriptableObject {
        private FallbackCaller() {
        }

        @Override
        public Object get(String name, Scriptable start) {
            if (start instanceof ScriptableWithFallbackGetter) {
                return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
            }
            return NOT_FOUND;
        }

        @Override
        public String getClassName() {
            return "htmlUnitHelper-fallbackCaller";
        }
    }
}

