/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.Clock;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SnapshotScreenListener;
import org.openqa.selenium.remote.server.SystemClock;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class DefaultSession
implements Session {
    private static final String QUIET_EXCEPTIONS_KEY = "webdriver.remote.quietExceptions";
    private final SessionId sessionId;
    private final WebDriver driver;
    private final KnownElements knownElements = new KnownElements();
    private final ThreadPoolExecutor executor;
    private final Capabilities capabilities;
    private final Clock clock;
    private volatile String base64EncodedImage;
    private volatile long lastAccess;
    private volatile Thread inUseWithThread = null;
    private TemporaryFilesystem tempFs;

    public static Session createSession(DriverFactory factory, SessionId sessionId, Capabilities capabilities) throws Exception {
        return DefaultSession.createSession(factory, new SystemClock(), sessionId, capabilities);
    }

    public static Session createSession(DriverFactory factory, Clock clock, SessionId sessionId, Capabilities capabilities) throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), sessionId.toString());
        if (!tmpDir.mkdir()) {
            throw new WebDriverException("Cannot create temp directory: " + tmpDir);
        }
        TemporaryFilesystem tempFs = TemporaryFilesystem.getTmpFsBasedOn(tmpDir);
        return new DefaultSession(factory, tempFs, clock, sessionId, capabilities);
    }

    @VisibleForTesting
    public static Session createSession(DriverFactory factory, TemporaryFilesystem tempFs, Clock clock, SessionId sessionId, Capabilities capabilities) throws Exception {
        return new DefaultSession(factory, tempFs, clock, sessionId, capabilities);
    }

    private DefaultSession(DriverFactory factory, TemporaryFilesystem tempFs, Clock clock, SessionId sessionId, Capabilities capabilities) throws Exception {
        this.sessionId = sessionId;
        this.tempFs = tempFs;
        this.clock = clock;
        BrowserCreator browserCreator = new BrowserCreator(factory, capabilities);
        FutureTask<EventFiringWebDriver> webDriverFutureTask = new FutureTask<EventFiringWebDriver>(browserCreator);
        this.executor = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        EventFiringWebDriver initialDriver = this.execute(webDriverFutureTask);
        if (!DefaultSession.isQuietModeEnabled(browserCreator, capabilities)) {
            initialDriver.register(new SnapshotScreenListener(this));
        }
        this.driver = initialDriver;
        this.capabilities = browserCreator.getCapabilityDescription();
        this.updateLastAccessTime();
    }

    private static boolean isQuietModeEnabled(BrowserCreator browserCreator, Capabilities capabilities) {
        if (browserCreator.isAndroid()) {
            return true;
        }
        boolean propertySaysQuiet = "true".equalsIgnoreCase(System.getProperty(QUIET_EXCEPTIONS_KEY));
        if (capabilities == null) {
            return propertySaysQuiet;
        }
        if (capabilities.is(QUIET_EXCEPTIONS_KEY)) {
            return true;
        }
        Object cap = capabilities.asMap().get(QUIET_EXCEPTIONS_KEY);
        boolean isExplicitlyDisabledByCapability = cap != null && "false".equalsIgnoreCase(cap.toString());
        return propertySaysQuiet && !isExplicitlyDisabledByCapability;
    }

    @Override
    public void updateLastAccessTime() {
        this.lastAccess = this.clock.now();
    }

    @Override
    public boolean isTimedOut(long timeout) {
        return timeout > 0L && this.lastAccess + timeout < this.clock.now();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        if (this.tempFs != null) {
            this.tempFs.deleteTemporaryFiles();
            this.tempFs.deleteBaseDir();
        }
    }

    @Override
    public <X> X execute(final FutureTask<X> future) throws Exception {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultSession.this.inUseWithThread = Thread.currentThread();
                DefaultSession.this.inUseWithThread.setName("Session " + DefaultSession.this.sessionId + " processing inside browser");
                try {
                    future.run();
                }
                finally {
                    DefaultSession.this.inUseWithThread = null;
                    Thread.currentThread().setName("Session " + DefaultSession.this.sessionId + " awaiting client");
                }
            }
        });
        return future.get();
    }

    @Override
    public WebDriver getDriver() {
        this.updateLastAccessTime();
        return this.driver;
    }

    @Override
    public KnownElements getKnownElements() {
        return this.knownElements;
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void attachScreenshot(String base64EncodedImage) {
        this.base64EncodedImage = base64EncodedImage;
    }

    @Override
    public String getAndClearScreenshot() {
        String temp = this.base64EncodedImage;
        this.base64EncodedImage = null;
        return temp;
    }

    @Override
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public TemporaryFilesystem getTemporaryFileSystem() {
        return this.tempFs;
    }

    @Override
    public boolean isInUse() {
        return this.inUseWithThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Thread threadToStop = this.inUseWithThread;
        if (threadToStop != null) {
            Thread thread = threadToStop;
            synchronized (thread) {
                threadToStop.interrupt();
            }
        }
    }

    private class BrowserCreator
    implements Callable<EventFiringWebDriver> {
        private final DriverFactory factory;
        private final Capabilities capabilities;
        private volatile Capabilities describedCapabilities;
        private volatile boolean isAndroid = false;

        BrowserCreator(DriverFactory factory, Capabilities capabilities) {
            this.factory = factory;
            this.capabilities = capabilities;
        }

        @Override
        public EventFiringWebDriver call() throws Exception {
            WebDriver rawDriver = this.factory.newInstance(this.capabilities);
            Capabilities actualCapabilities = this.capabilities;
            if (rawDriver instanceof HasCapabilities) {
                actualCapabilities = ((HasCapabilities)((Object)rawDriver)).getCapabilities();
                this.isAndroid = actualCapabilities.getPlatform().is(Platform.ANDROID);
            }
            this.describedCapabilities = this.getDescription(rawDriver, actualCapabilities);
            return new EventFiringWebDriver(rawDriver);
        }

        public Capabilities getCapabilityDescription() {
            return this.describedCapabilities;
        }

        public boolean isAndroid() {
            return this.isAndroid;
        }

        private DesiredCapabilities getDescription(WebDriver instance, Capabilities capabilities) {
            DesiredCapabilities caps = new DesiredCapabilities(capabilities.asMap());
            caps.setJavascriptEnabled(instance instanceof JavascriptExecutor);
            if (instance instanceof TakesScreenshot) {
                caps.setCapability("takesScreenshot", true);
            }
            if (instance instanceof LocationContext) {
                caps.setCapability("locationContextEnabled", true);
            }
            if (instance instanceof ApplicationCache) {
                caps.setCapability("applicationCacheEnabled", true);
            }
            if (instance instanceof NetworkConnection) {
                caps.setCapability("networkConnectionEnabled", true);
            }
            if (instance instanceof WebStorage) {
                caps.setCapability("webStorageEnabled", true);
            }
            if (instance instanceof FindsByCssSelector) {
                caps.setCapability("cssSelectorsEnabled", true);
            }
            if (instance instanceof Rotatable) {
                caps.setCapability("rotatable", true);
            }
            if (instance instanceof HasTouchScreen) {
                caps.setCapability("hasTouchScreen", true);
            }
            return caps;
        }
    }
}

